<?php
require_once '../../config/database.php';
checkAuth();

$user_id = $_SESSION['user_id'];
$user = getUser($user_id);

// Get products
$products = $pdo->prepare("SELECT * FROM products WHERE user_id = ? OR user_id IS NULL");
$products->execute([$user_id]);
$products = $products->fetchAll();

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $invoice_number = generateInvoiceNumber();
    $invoice_date = $_POST['invoice_date'];
    $due_date = $_POST['due_date'];
    $billing_type = $_POST['billing_type'];
    $client_name = $_POST['client_name'];
    $client_address = $_POST['client_address'];
    $client_gstin = $_POST['client_gstin'];
    $notes = $_POST['notes'];
    
    $subtotal = 0;
    $tax_amount = 0;
    
    // Calculate totals
    foreach ($_POST['items'] as $item) {
        if (!empty($item['description'])) {
            $quantity = floatval($item['quantity']);
            $price = floatval($item['price']);
            $tax_rate = floatval($item['tax_rate']);
            
            $item_total = $quantity * $price;
            $subtotal += $item_total;
            
            if ($billing_type == 'gst') {
                $tax_amount += $item_total * ($tax_rate / 100);
            }
        }
    }
    
    $total_amount = $subtotal + $tax_amount;
    
    try {
        $pdo->beginTransaction();
        
        // Insert invoice
        $stmt = $pdo->prepare("INSERT INTO invoices (invoice_number, user_id, invoice_date, due_date, billing_type, subtotal, tax_amount, total_amount, client_name, client_address, client_gstin, notes) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        $stmt->execute([$invoice_number, $user_id, $invoice_date, $due_date, $billing_type, $subtotal, $tax_amount, $total_amount, $client_name, $client_address, $client_gstin, $notes]);
        $invoice_id = $pdo->lastInsertId();
        
        // Insert items
        $stmt = $pdo->prepare("INSERT INTO invoice_items (invoice_id, product_id, description, quantity, unit_price, tax_rate, total) VALUES (?, ?, ?, ?, ?, ?, ?)");
        
        foreach ($_POST['items'] as $item) {
            if (!empty($item['description'])) {
                $quantity = floatval($item['quantity']);
                $price = floatval($item['price']);
                $tax_rate = floatval($item['tax_rate']);
                $item_total = $quantity * $price;
                
                $stmt->execute([$invoice_id, $item['product_id'], $item['description'], $quantity, $price, $tax_rate, $item_total]);
            }
        }
        
        $pdo->commit();
        header("Location: view.php?id=$invoice_id&success=Invoice created successfully");
        exit;
    } catch (Exception $e) {
        $pdo->rollBack();
        $error = "Error creating invoice: " . $e->getMessage();
    }
}
?>

<?php include '../../includes/header.php'; ?>

<div class="card">
    <div class="card-header">
        <h4><i class="fas fa-plus"></i> Create New Invoice</h4>
    </div>
    <div class="card-body">
        <?php if (isset($error)): ?>
            <div class="alert alert-danger"><?php echo $error; ?></div>
        <?php endif; ?>
        
        <form method="POST" id="invoiceForm">
            <div class="row mb-4">
                <div class="col-md-6">
                    <div class="mb-3">
                        <label class="form-label">Billing Type *</label>
                        <select name="billing_type" class="form-select" id="billingType" required>
                            <option value="non_gst">Non-GST</option>
                            <option value="gst">GST</option>
                        </select>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="mb-3">
                        <label class="form-label">Invoice Date *</label>
                        <input type="date" name="invoice_date" class="form-control" value="<?php echo date('Y-m-d'); ?>" required>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="mb-3">
                        <label class="form-label">Due Date</label>
                        <input type="date" name="due_date" class="form-control">
                    </div>
                </div>
            </div>
            
            <div class="row mb-4">
                <div class="col-md-6">
                    <h5>Client Details</h5>
                    <div class="mb-3">
                        <label class="form-label">Client Name *</label>
                        <input type="text" name="client_name" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Client Address</label>
                        <textarea name="client_address" class="form-control" rows="3"></textarea>
                    </div>
                    <div class="mb-3" id="gstinField" style="display: none;">
                        <label class="form-label">Client GSTIN</label>
                        <input type="text" name="client_gstin" class="form-control">
                    </div>
                </div>
                <div class="col-md-6">
                    <h5>Your Details</h5>
                    <div class="card bg-light">
                        <div class="card-body">
                            <strong><?php echo htmlspecialchars($user['company_name'] ?: $user['username']); ?></strong><br>
                            <?php echo nl2br(htmlspecialchars($user['address'])); ?><br>
                            <?php if ($user['phone']): ?>Phone: <?php echo htmlspecialchars($user['phone']); ?><br><?php endif; ?>
                            <?php if ($user['gstin']): ?>GSTIN: <?php echo htmlspecialchars($user['gstin']); ?><br><?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
            
            <h5>Items</h5>
            <div class="table-responsive">
                <table class="table" id="itemsTable">
                    <thead>
                        <tr>
                            <th>Item Description</th>
                            <th width="100">Quantity</th>
                            <th width="150">Unit Price (₹)</th>
                            <th width="120" id="taxHeader" style="display: none;">Tax Rate (%)</th>
                            <th width="120">Amount (₹)</th>
                            <th width="50">Action</th>
                        </tr>
                    </thead>
                    <tbody id="itemsBody">
                        <tr>
                            <td>
                                <input type="text" name="items[0][description]" class="form-control" placeholder="Item description">
                                <input type="hidden" name="items[0][product_id]" value="0">
                            </td>
                            <td>
                                <input type="number" name="items[0][quantity]" class="form-control quantity" value="1" min="1" step="0.01">
                            </td>
                            <td>
                                <input type="number" name="items[0][price]" class="form-control price" value="0" min="0" step="0.01">
                            </td>
                            <td class="tax-field" style="display: none;">
                                <select name="items[0][tax_rate]" class="form-select tax-rate">
                                    <option value="0">0%</option>
                                    <option value="5">5%</option>
                                    <option value="12">12%</option>
                                    <option value="18">18%</option>
                                    <option value="28">28%</option>
                                </select>
                            </td>
                            <td>
                                <input type="text" class="form-control item-total" value="0.00" readonly>
                            </td>
                            <td>
                                <button type="button" class="btn btn-danger btn-sm remove-item" disabled>
                                    <i class="fas fa-times"></i>
                                </button>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
            
            <div class="mb-3">
                <button type="button" class="btn btn-success" id="addItem">
                    <i class="fas fa-plus"></i> Add Item
                </button>
            </div>
            
            <div class="row justify-content-end">
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-body">
                            <div class="d-flex justify-content-between mb-2">
                                <span>Subtotal:</span>
                                <span id="subtotal">₹0.00</span>
                            </div>
                            <div class="d-flex justify-content-between mb-2" id="taxRow" style="display: none;">
                                <span>Tax:</span>
                                <span id="taxAmount">₹0.00</span>
                            </div>
                            <div class="d-flex justify-content-between mb-2 fw-bold">
                                <span>Total:</span>
                                <span id="totalAmount">₹0.00</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="mb-3">
                <label class="form-label">Notes</label>
                <textarea name="notes" class="form-control" rows="3" placeholder="Additional notes..."></textarea>
            </div>
            
            <div class="d-flex gap-2">
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-save"></i> Create Invoice
                </button>
                <a href="../../dashboard.php" class="btn btn-secondary">Cancel</a>
            </div>
        </form>
    </div>
</div>

<script>
const products = <?php echo json_encode($products); ?>;
</script>

<?php include '../../includes/footer.php'; ?>